## Build and Deploy Modern Web Applications with AWS Amplify - Base Code 

This project repository serves as the base code for the workshop built for the AWS ASEAN SA LEAP Day (May 2021) - Study Jam Room 3. Resources associated with the study jam will be documented [here](https://master.dymygafqleecg.amplifyapp.com/). If you any feedback or require any additional information, please reach out to me at thaiwg@amazon.com.
 
### What is this workshop for? 
Through this workshop, developers will start with a modern static web application built with the ReactJS framework - which is reminiscent to the needs of many of our customers across Enterprises, Digital Native Businesses and Startups. They will host the application on AWS through the Amplify framework, and incorporate additional modules that are available within the Amplify arsenal. Those modules include common customer use-cases of a CI/CD pipeline, user authentication, storage, and even chatbot integration.

* Module 1 – Local Deployment
* Module 2 – Automated Deployments to AWS Amplify
* Module 3 – User Authentication
* Module 4 – Integrating Storage Capabilities
* Module 5 – Chatbot Integration

### Who is this Workshop for?
This workshop is an introductory course aimed at developers/SAs with limited hands-on experience with modern web development technologies and hands-on experience with AWS Amplify.


### What does this workshop aim to accomplish? 
After completing this workshop, developers/SAs will be provided with a high level understanding of the Amplify framework and be better enabled to help customers address common workload needs of a modern web application.

## Authors
* Glendon Thaiw, AWS ([GitHub](https://github.com/glendont) | [LinkedIn](https://www.linkedin.com/in/glendonthaiw/))
